﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Catalogue
{
    public partial class FamilleMedicament : Form
    {
        

        public Medicament medicament = new Medicament();  //Permet de pouvoir ouvrir après le form Medicament

        public static string medicamentSelectionne;  //Pour récupérer le nom du médicament sélectionné

        public FamilleMedicament()
        {
            InitializeComponent();
        }

        private void btnRetour_Click(object sender, EventArgs e)
        {
            Accueil.nomMedicament = "";
            Accueil.fermerAccueil = false;
            this.Close();
        }

        private void FamilleMedicament_Load(object sender, EventArgs e)
        {

            //Changement libelle
            lblFamille.Text = Accueil.famille;
            lblGroupe.Text = Accueil.groupe;

            //Remplissage de la liste des medicaments
            dgvMedicament.DataSource = Métiers.FamilleMedicament.listeMedicament(Accueil.famille);

            //Gestion de la largeur des colonnes
            dgvMedicament.Columns[0].Width = 100; //Nom
            dgvMedicament.Columns[1].Width = 287; //Effets
            dgvMedicament.Columns[2].Width = 287; //Contreindications

        }

        

        

        private void FamilleMedicament_Activated(object sender, EventArgs e)
        {
            if (Accueil.fermerAccueil == true)
            {
                Accueil.fermerAccueil = false;
                this.Close();
            }
        }



        private void txtBarreRecherche_TextChanged(object sender, EventArgs e)
        {
            dgvMedicament.DataSource = Métiers.FamilleMedicament.listeMedicamentBarreRecherche(txtBarreRecherche.Text, Accueil.groupe, Accueil.famille);
        }



        private void dgvMedicament_RowHeaderMouseDoubleClick_1(object sender, DataGridViewCellMouseEventArgs e)
        {
            DataRowView drvMedicament = (DataRowView)dgvMedicament.SelectedRows[0].DataBoundItem;
            medicamentSelectionne = drvMedicament.Row[0].ToString();

            //Ouverture du form FamilleMedicament
            Medicament medicament = new Medicament();
            medicament.Show(this);
        }




    }
}
